/**
 * Beschrijft een radiokanaal
 *
 * @author Dominiek Vandewalle
 * @version 2014-11-19
 */
public class Kanaal
{
    private double frequentie;//FM-frequentie van het radiokanaal
    private String naam;//naam van de radiozender
    
    /**
     * Constructor voor objecten van de klasse Kanaal.
     * @param   frequentie  De FM-frequentie van het kanaal.
     * @param   naam        De naam van het radiokanaal.
     */
    public Kanaal(double frequentie, String naam)
    {
        this.frequentie = frequentie;
        this.naam = naam;
    }
    
    /**
     * Geeft de frequentie van het radiokanaal terug.
     * @return  De FM-frequentie van het radiokanaal.
     */
    public double getFrequentie()
    {
        return frequentie;
    }

    /**
     * Geeft de naam van het radiokanaal terug.
     * @return De naam van het radiokanaal.
     */
    public String getNaam()
    {
        return naam;
    }
    
    /**
     * Print frequentie en naam van het radiokanaal naar het terminalvenster.
     */
    public void print()
    {
        System.out.println(frequentie + " - " + naam);
    }
}
